/*-----------------------------------------------------------------------------
 * sdq.h
 * EV2400 firmware
 * 
 * Jennie Kam
 * Version 0.5
 * Last updated: 5/28/09
 * 
 * Peripherials used:
 * 
 * Timer A1, CCR1 (port 1), CCR2 (port 2), from 1MHz ACLK, no divider
 * Timer A1, CCR0 (timeout), from 1MHz ACLK, no divider
 * Timer 0, B, CCR3 (pulse output), from 1MHz ACLK, no divider 
 * ---------------------------------------------------------------------------*/
 
#ifndef SDQ_H_
#define SDQ_H_

#include <msp430x23x0.h>

#define P1_SDQ     BIT2                     // TA1 pin on PORT1

#define tSDQzero    80           // 80 microseconds
#define tSDQone     8          // 8 microseconds
#define tSDQreset   480         // 480 microseconds


/*----------------------------------------------------------------------------+
| Timer A ISR variables
+----------------------------------------------------------------------------*/
//extern unsigned char dq_flag;
extern unsigned char ISRMode, write_done, Wcompleted, Rresponse, pulse_done;

/*----------------------------------------------------------------------------+
| Functions
+----------------------------------------------------------------------------*/
void SDQBitWrite(unsigned char data);
void SDQByteWrite(unsigned char data);
unsigned char SDQBitRead(void);
unsigned char SDQByteRead(void);
void SDQresetpulse(void);
// Returns a 1 if presence pulse is detected, 0 otherwise
// Length should always be 480 (microseconds)

#endif /*SDQ_H_*/
